// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     chrome/browser/media/router/media_router.mojom
//

package org.chromium.mojom.media_router.interfaces;

public final class MediaSink extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 32;
    private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(32, 0)};
    private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

    public static final class IconType {
    
        public static final int CAST = 0;
        public static final int CAST_AUDIO = CAST + 1;
        public static final int CAST_AUDIO_GROUP = CAST_AUDIO + 1;
        public static final int GENERIC = CAST_AUDIO_GROUP + 1;
        public static final int HANGOUT = GENERIC + 1;
    
        private IconType() {}
    
    }

    public String sinkId;
    public String name;
    public int iconType;

    private MediaSink(int version) {
        super(STRUCT_SIZE, version);
    }

    public MediaSink() {
        this(0);
    }

    public static MediaSink deserialize(org.chromium.mojo.bindings.Message message) {
        return decode(new org.chromium.mojo.bindings.Decoder(message));
    }

    @SuppressWarnings("unchecked")
    public static MediaSink decode(org.chromium.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
        MediaSink result = new MediaSink(mainDataHeader.elementsOrVersion);
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.sinkId = decoder0.readString(8, false);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.name = decoder0.readString(16, false);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.iconType = decoder0.readInt(24);
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        encoder0.encode(sinkId, 8, false);
        encoder0.encode(name, 16, false);
        encoder0.encode(iconType, 24);
    }

    /**
     * @see Object#equals(Object)
     */
    @Override
    public boolean equals(Object object) {
        if (object == this)
            return true;
        if (object == null)
            return false;
        if (getClass() != object.getClass())
            return false;
        MediaSink other = (MediaSink) object;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.sinkId, other.sinkId))
            return false;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.name, other.name))
            return false;
        if (this.iconType != other.iconType)
            return false;
        return true;
    }

    /**
     * @see Object#hashCode()
     */
    @Override
    public int hashCode() {
        final int prime = 31;
        int result = prime + getClass().hashCode();
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(sinkId);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(name);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(iconType);
        return result;
    }
}

